#!/tvbin/tivosh
#
# Play MP3s in the Tivo GUI
#
# Requirements:
#
#	   newtext2osd 1.4 
#	   madplay (mp3 player)
#	   ps 
#
# UK Tivos need the MWSTATE bugfix in place
#
#

source $tcl_library/tv/sendkey.tcl
set verboseSendKeyG 0

# edit to wherever you store MP3s

    set mp3dir "/var/mp3"
    set mp3ext ".mp3"

# If those commands are in your path:
#    set pscmd "ps"
#    set playcmd "madplay"
    
    set pscmd "/var/hack/bin/ps"
    set playcmd "/var/hack/bin/madplay"

set offset 0
set menu 0

proc txtout { string line  }   {
	set line [expr $line -2 ]
        set string "$string                                            " 
        set string [string range $string 0 34 ]
	exec /var/hack/bin/newtext2osd -e --fg white3 --bg blue3  -x 5 -y $line -t "$string"
}

proc EventCallback { type subtype } {
global EventData CurrentContext
 if { $type == $TmkEvent::EVT_MW_STATUS } {
   if { $subtype == $TmkEventMwStatus::CONTEXT_CHANGE || \
        $subtype == $TmkEventMwStatus::CONTEXT_PING_ACK } {
    binary scan $EventData I CurrentContext
   }
  }
}

proc keycallback { type subtype } {
global EventData CurrentContext Serial mwStateG
global menu offset mp3list

binary scan $EventData II data Serial 
if { $type == $TmkEvent::EVT_REMOTEEVENT  && $subtype == 0 && $CurrentContext == 7} {
	# Only look for "7" key to activate menu:
      if { $menu == 0 } { 
      		if { $data == $::evrc(7) } { 
			set menu 1
			mp3menu 0
			}

		} else {
	# We are already showing a menu and running:

      if { $data == $::evrc(surfup) } { 
		if {$offset >= 3} {
				set offset [expr $offset - 3] 
				mp3menu $offset 
				}
		}
      if { $data == $::evrc(surfdown) } { 
		if {$offset < [expr [llength $mp3list] - 3] } {
				set offset [expr $offset + 3] 
				mp3menu $offset 
				}
		}

      if { $data == $::evrc(1) } { 
		playmp3 [lindex $mp3list [expr $offset +1]]
		}
      if { $data == $::evrc(2) } { 
		playmp3 [lindex $mp3list [expr $offset +2]]
		}
      if { $data == $::evrc(3) } { 
		playmp3 [lindex $mp3list [expr $offset +3]]
		}
      if { $data == $::evrc(7) } { 
		killmp3
		if {$menu > 0} { 
			set menu [expr $menu -1]
			if {$menu==0} {clearmenu}
			} else { set menu 1 }
		mp3menu $offset
		}

	}
}

}

proc clearmenu {} {
txtout "" 1
txtout "" 2
txtout "" 3
}
proc playmp3 {mp3file} {
global menu mp3dir mp3ext playcmd


		killmp3
		set menu 2
		set currmp3 "$mp3file$mp3ext"
		#SendKey "tivo"
		
		exec ln -f -s "$mp3dir/$currmp3" /tmp/nowplaying.mp3
		set lowpri "setpri fifo 1 $$"
		set mp3start "$playcmd --downsample --no-dither -Q /tmp/nowplaying.mp3 &>/dev/null &"
		set mp3handler [open |/bin/sh w+]
		#puts $mp3handler $lowpri
		puts $mp3handler $mp3start
		close $mp3handler
		set outfil [open "/tmp/mp3nowplaying" w]
		puts $outfil $currmp3
		close $outfil
    		playingmenu
}
proc killmp3 {} {
global pscmd
	set madprocs [exec $pscmd ax]
	foreach line [split $madprocs "\n\r"] {
		if {[regexp -nocase "madplay" $line]} {
			set killmadpid [lindex $line 0]
			kill -9 $killmadpid
		    }
		}
	}


proc mp3menu { offset } {
global menu mp3list
if {$menu} {
	set x $offset
	set end [expr $offset +3]
	while {$x <= $end } {
		set key [expr $x - $offset]
		txtout "$key) [lindex $mp3list $x]" $key
		set x [expr $x + 1]
		}
	} 
}

proc playingmenu {} {
global pscmd

if {[regexp -nocase madplay [exec $pscmd ax ]] && [file exists "/tmp/mp3nowplaying"]} {
	set mp3nowplaying [file rootname [exec cat /tmp/mp3nowplaying]]

	txtout "$mp3nowplaying" 1
	txtout [string range $mp3nowplaying 35 68] 2
	txtout "7) stop" 3
      }
}


# MAIN CODE 

set CurrentContext 0

event register $TmkEvent::EVT_MW_STATUS   EventCallback
event register $TmkEvent::EVT_REMOTEEVENT keycallback

if { $CurrentContext == 0 } {
 set verboseSendKeyG 0
 SendKey ping
 vwait CurrentContext
}


set dirinfo [glob "$mp3dir/*$mp3ext"]
foreach line  $dirinfo { lappend mp3list [file tail [file rootname $line]] }


while {1} {

# stop playing mp3s when live-tv or Playing a show:
if { $CurrentContext == 6 } { killmp3 }

if { $CurrentContext == 7 } {
	mp3menu 0
	playingmenu 
}

 vwait CurrentContext
}
