/* get_space
 * 2002 Mike Baker <mbm@linux.com>
 * GPL'd
 * Heavily derived from the work of Andrew Tridgell
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <asm/unistd.h>
#include <sys/ioctl.h>
#include <linux/ide-tivo.h>

#define MAX_ZONES 32
#define MAX_DEVS 64
#define SECTOR_SIZE 512
#define MFS_BLOCK_ROUND 1024
#define BLKGETSIZE 0x20001260

struct super {
	char devlist[128];
	unsigned total_sectors;
	unsigned fill3[7];
	unsigned zonemap_ptr;
	unsigned backup_zonemap_ptr;
	unsigned zonemap_size;
};

struct zone {
	unsigned sector;
	unsigned backup_sector;
	unsigned zonemap_size;
	unsigned next_zonemap_ptr;
	unsigned backup_next_zonemap_ptr;
	unsigned next_zonemap_size;
	unsigned next_zone_size;
	unsigned next_zone_perchunk;
	unsigned type;
	unsigned fill3;
	unsigned crc;
	unsigned zone_start;
	unsigned next_zone_ptr1;
	unsigned zone_size;
	unsigned per_chunk;
	unsigned available_space;
	unsigned fill4;
	unsigned buddy_size;
	unsigned mapdata[0];
};

struct {
	unsigned sectors;
	int fd;
} devs[MAX_DEVS];

void load_devs(char *devlist) {
	int num_devs=0;
	char *ptr=strtok(devlist," ");
	while (ptr) {
		devs[num_devs].fd=open(ptr,O_RDONLY);
		ioctl(devs[num_devs].fd, BLKGETSIZE, &devs[num_devs].sectors);
		devs[num_devs].sectors &= ~(MFS_BLOCK_ROUND-1);
//		printf("%d %s 0x%08x\n",num_devs,ptr,(unsigned)devs[num_devs].sectors);
		ptr=strtok(NULL," ");
		num_devs++;
	}
	devs[num_devs].sectors=0;
}

int mfs_read_sectors(void *buf, unsigned sec, unsigned count)
{
	unsigned i;
	struct FsIovec vec;
	struct FsIoRequest req;
	off_t offset;

	for (i=0; devs[i].sectors; i++) {
		if (sec<devs[i].sectors) break;
		sec -= devs[i].sectors;
	}
#ifdef __powerpc__
	vec.pb = buf;
	vec.cb = count*SECTOR_SIZE;
	req.sector = sec;
	req.num_sectors = count;
	req.deadline = 0;

	return syscall(__NR_readsectors, devs[i].fd, &vec, 1, &req);
#else
	offset = (off_t) sec * SECTOR_SIZE;
	lseek(devs[i].fd, offset, SEEK_SET);
	return read(devs[i].fd, buf, count * SECTOR_SIZE);
#endif
}

int main(int argc , char **argv) {
	unsigned next=0, map_size=0, num_zone=0;
	struct super *super = (struct super *)malloc(sizeof(struct super));
	struct zone   *zone[MAX_ZONES];
	unsigned totals[2][3];

	memset(totals,0,sizeof(totals));

	devs[0].fd=open("/dev/hda10",O_RDONLY);
	lseek(devs[0].fd,0x24,SEEK_SET);
	read(devs[0].fd,super,sizeof(struct super));
	load_devs(super->devlist);

	next = super->zonemap_ptr;
	map_size = super->zonemap_size;

	while (next) {
		zone[num_zone] = (struct zone *)malloc(SECTOR_SIZE*map_size);
		mfs_read_sectors(zone[num_zone],next,map_size);
#if 0
	printf("zone[%d] type: %d %8d avail: %8d\n",
	num_zone,
	zone[num_zone]->type,
	zone[num_zone]->zone_size,
	zone[num_zone]->available_space);
#endif
		totals[0][zone[num_zone]->type] += zone[num_zone]->zone_size;
		totals[1][zone[num_zone]->type] += zone[num_zone]->available_space;

		next = zone[num_zone]->next_zonemap_ptr;
		map_size = zone[num_zone]->zonemap_size;
		num_zone++;
	}
	printf("%d %d %d %d\n",totals[0][1],totals[1][1],totals[0][2],totals[1][2]);
	return 0;
}
